function cb_m53 
% Menu 53
% Frequency response loads

  global persParamsDir
  global Rls                   
  global Cls
  global sfontsize
  global m53
  
  kw=20/sfontsize;
  capt = get(m53,'label');  
  rowscols = [1,30*kw; 1,30*kw];
  prompt={};
  prompt{1} = 'Rload(i) / kOhm (enter 3 values)';
  prompt{2} = 'Cload(i) / pF (enter 3 values)'; 
  defaults{1} = num2str(Rls/1000,4);
  defaults{2} = num2str(Cls/1e-12,4); 
  
  result= inputdlg (prompt, capt, rowscols, defaults);
  
  if ~isempty(result)    
    num=real(str2num(result{1}));    
    if ~isempty(num)
      for i=1:3
        Rls(i)=num(1,i)*1000;
        if (Rls(i) < 100) Rls(i) = 100; end
        if (Rls(i) > 10e9) Rls(i) = 10e9; end
      end
    end 
    num=real(str2num(result{2})); 
    if ~isempty(num) 
      for i=1:3
        Cls(i)=num(1,i)*1e-12;
        if (Cls(i) < 1e-15) Cls(i) = 1e-15; end
        if (Cls(i) > 1e-6)Cls(i) = 1e-6; end 
      end
    end     
    sn = strcat(persParamsDir,'loadParams.mat');
    save('-mat',sn, 'Rls', 'Cls');      
  end 
  
end
